	function creps = gencoeffreps(h, wc, signed)
	%creps = gencoeffreps(h, wc, signed)
	%
	%Generates representations for the impulse response coefficients of an FIR
	%filter. Currently implemented representations are binary and minimum
	%signed digit.
	%
	%Arguments:
	%  h - the impulse response
	%  wc - the coefficient wordlength to use
	%  signed - signedness of coefficients
	%
	%Returns:
	%  creps - structure containing the coefficient representations, to be
	%          used in calls to chooserep.
	
	%Copyright 2008, 2010 Anton Blad
	%
	%This file is part of firgen.
	%
	%firgen is free software: you can redistribute it and/or modify
	%it under the terms of the GNU General Public License as published by
	%the Free Software Foundation, either version 3 of the License, or
	%(at your option) any later version.
	%
	%firgen is distributed in the hope that it will be useful,
	%but WITHOUT ANY WARRANTY; without even the implied warranty of
	%MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	%GNU General Public License for more details.
	%
	%You should have received a copy of the GNU General Public License
	%along with firgen.  If not, see <http://www.gnu.org/licenses/>
	
	N = length(h);
	
	creps.h = h;
	creps.wc = wc;
	
	creps.bin = cell(1, N);
	for n = 1:N
		creps.bin{n} = dectobin(h(n), wc, signed);
	end
	
	creps.msd = cell(1, N);
	for n = 1:N
		creps.msd{n} = genmsdcoeffs(h(n), wc, signed);
	end
	
